<?php

namespace App;

use App\Scopes\AcademicSchoolScope;
use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class SmExamSchedule extends Model
{
    use HasFactory;

    protected $fillable = [];

    public static function assignedRoutine($class_id, $section_id, $exam_id, $subject_id, $exam_period_id)
    {
        try {
            return self::where('class_id', $class_id)
                ->where('section_id', $section_id)
                ->where('exam_term_id', $exam_id)
                ->where('subject_id', $subject_id)
                ->where('exam_period_id', $exam_period_id)
                ->where('academic_id', getAcademicId())
                ->where('school_id', Auth::user()->school_id)
                ->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function assignedRoutineSubject($class_id, $section_id, $exam_id, $subject_id)
    {
        try {
            return self::where('class_id', $class_id)
                ->where('section_id', $section_id)
                ->where('exam_term_id', $exam_id)
                ->where('subject_id', $subject_id)
                ->where('academic_id', getAcademicId())
                ->where('school_id', Auth::user()->school_id)
                ->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function assigned_date_wise_exams($exam_period_id, $exam_term_id, $date)
    {
        try {
            return self::where('exam_period_id', $exam_period_id)->where('date', $date)->where('exam_term_id', $exam_term_id)->get();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function assignedRoutineSubjectStudent($class_id, $section_id, $exam_id, $subject_id, $exam_period_id)
    {

        try {
            return self::where('class_id', $class_id)->where('section_id', $section_id)->where('exam_term_id', $exam_id)->where('subject_id', $subject_id)->where('exam_period_id', $exam_period_id)->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function examScheduleSubject($class_id, $section_id, $exam_id, $exam_period_id, $date)
    {
        try {
            return self::where('class_id', $class_id)->where('section_id', $section_id)
                ->where('exam_term_id', $exam_id)->where('exam_period_id', $exam_period_id)
                ->where('date', $date)
                ->first();
        } catch (Exception $exception) {
            return [];
        }
    }

    public static function getAllExams($class_id, $section_id, $exam_type_id,$shift_id =null)
    {
        try {
            return SmExamSchedule::where('class_id', $class_id)
                    ->where('section_id', $section_id)
                    ->when($shift_id, function ($query, $shift_id) {
                        return $query->where('shift_id', $shift_id);
                    })
                    ->where('exam_term_id', $exam_type_id)
                    ->orderBy('date', 'ASC')
                    ->get();
        } catch (\Exception $e) {
            return '';
        }
    }
    public function shift(){
        return $this->belongsTo(\App\Models\Shift::class, 'shift_id', 'id');
    }

    public function examSchedule()
    {
        return $this->hasMany(SmExamScheduleSubject::class, 'exam_schedule_id', 'id');
    }

    public function examType()
    {
        return $this->belongsTo(SmExamType::class, 'exam_term_id', 'id');
    }

    public function exam()
    {
        return $this->belongsTo(SmExam::class, 'exam_id', 'id');
    }

    public function class()
    {
        return $this->belongsTo(SmClass::class, 'class_id', 'id');
    }

    public function classApi()
    {
        return $this->belongsTo(SmClass::class, 'class_id', 'id')->withoutGlobalScopes();
    }

    public function section()
    {
        if (moduleStatusCheck('University')) {
            return $this->belongsTo(SmSection::class, 'un_section_id', 'id');
        }

        return $this->belongsTo(SmSection::class, 'section_id', 'id');

    }

    public function sectionApi()
    {
        if (moduleStatusCheck('University')) {
            return $this->belongsTo(SmSection::class, 'un_section_id', 'id')->withoutGlobalScopes();
        }

        return $this->belongsTo(SmSection::class, 'section_id', 'id')->withoutGlobalScopes();

    }

    public function unSemesterLabel()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSemesterLabel::class, 'un_semester_label_id', 'id')->withDefault();
    }

    public function classRoom()
    {
        return $this->belongsTo(SmClassRoom::class, 'room_id', 'id');
    }

    public function classRoomApi()
    {
        return $this->belongsTo(SmClassRoom::class, 'room_id', 'id')->withoutGlobalScopes();
    }

    public function subject()
    {
        if (moduleStatusCheck('University')) {
            return $this->belongsTo(\Modules\University\Entities\UnSubject::class, 'un_subject_id', 'id');
        }

        return $this->belongsTo(SmSubject::class, 'subject_id', 'id');

    }

    public function subjectApi()
    {
        if (moduleStatusCheck('University')) {
            return $this->belongsTo(\Modules\University\Entities\UnSubject::class, 'un_subject_id', 'id')->withoutGlobalScopes();
        }

        return $this->belongsTo(SmSubject::class, 'subject_id', 'id')->withoutGlobalScopes();

    }

    public function teacher()
    {
        return $this->belongsTo(SmStaff::class, 'teacher_id', 'id');
    }

    public function teacherApi()
    {
        return $this->belongsTo(SmStaff::class, 'teacher_id', 'id')->withoutGlobalScopes();
    }

    public function subjectDetails()
    {
        return $this->belongsTo(\Modules\University\Entities\UnSubject::class, 'un_subject_id', 'id')->withDefault();
    }

    protected static function boot()
    {
        parent::boot();
        static::addGlobalScope(new AcademicSchoolScope);
    }
}
