<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class SchoolScope implements Scope
{
    public function apply(Builder $builder, Model $model): void
    {
        $table = $model->getTable();
        if (Auth::check()) {
            if (request('school_id')) {
                $builder->where($table.'.school_id', request('school_id'));
            } elseif (app()->bound('school')) {
                if (moduleStatusCheck('Saas') === true && auth()->user()->is_administrator === 'yes' && Session::get('isSchoolAdmin') === false && auth()->user()->role_id === 1) {
                    //
                } else {
                    $builder->where($table.'.school_id', app('school')->id);
                }
            } elseif (moduleStatusCheck('Saas') === true && auth()->user()->is_administrator === 'yes' && Session::get('isSchoolAdmin') === false && auth()->user()->role_id === 1) {
                //
            } else {
                $builder->where($table.'.school_id', auth()->user()->school_id);
            }
        }
    }
}
