@extends('backEnd.master')
@section('title')
    @lang('exam.question_level')
@endsection
@section('mainContent')
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1>@lang('exam.examinations')</h1>
                <div class="bc-pages">
                    <a href="{{ route('dashboard') }}">@lang('common.dashboard')</a>
                    <a href="#">@lang('exam.examinations')</a>
                    <a href="#">@lang('exam.question_level')</a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area">
        <div class="container-fluid p-0">
            @if (isset($level))
                <div class="row">
                    <div class="offset-lg-10 col-lg-2 text-right col-md-12 mb-20">
                        <a href="{{ route('question-level') }}" class="primary-btn small fix-gr-bg">
                            <span class="ti-plus pr-2"></span>
                            @lang('common.add')
                        </a>
                    </div>
                </div>
            @endif
            <div class="row">
                <div class="col-lg-3">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="main-title">
                                <h3 class="mb-30">
                                    @if (isset($level))
                                        @lang('exam.edit_question_level')
                                    @else
                                        @lang('exam.add_question_level')
                                    @endif
                                </h3>
                            </div>
                            @if (isset($level))
                                {{ html()->form('PUT', route('question-level', $level->id))->attributes([
                                        'class' => 'form-horizontal',
                                        'files' => true,
                                        'enctype' => 'multipart/form-data',
                                    ])->open() }}
                            @else
                                {{ html()->form('POST', route('question-level'))->attributes([
                                        'class' => 'form-horizontal',
                                        'files' => true,
                                        'enctype' => 'multipart/form-data',
                                    ])->open() }}
                            @endif
                            <div class="white-box">
                                <div class="add-visitor">

                                    <div class="row">
                                        <div class="col-lg-12">
                                            @if (session()->has('message-success'))
                                                <div class="alert alert-success">
                                                    {{ session()->get('message-success') }}
                                                </div>
                                            @elseif(session()->has('message-danger'))
                                                <div class="alert alert-danger">
                                                    {{ session()->get('message-danger') }}
                                                </div>
                                            @endif
                                            <div class="primary_input">
                                                <input
                                                    class="primary_input_field form-control{{ $errors->has('level') ? ' is-invalid' : '' }}"
                                                    type="text" name="level" autocomplete="off"
                                                    value="{{ isset($level) ? $level->level : '' }}">
                                                <input type="hidden" name="id"
                                                    value="{{ isset($level) ? $level->id : '' }}">
                                                <label class="primary_input_label" for="">@lang('common.title') <span
                                                        class="text-danger"> *</span></label>

                                                @if ($errors->has('level'))
                                                    <span class="text-danger">
                                                        {{ $errors->first('level') }}
                                                    </span>
                                                @endif
                                            </div>

                                        </div>
                                    </div>

                                    <div class="row mt-40">
                                        <div class="col-lg-12 text-center">
                                            <button class="primary-btn fix-gr-bg">
                                                <span class="ti-check"></span>

                                                @if (isset($level))
                                                    @lang('exam.save_level')
                                                @else
                                                    @lang('exam.update_level')
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{ html()->form()->close() }}
                        </div>
                    </div>
                </div>

                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-lg-4 no-gutters">
                            <div class="main-title">
                                <h3 class="mb-0"> @lang('exam.question_level_list')</h3>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">

                            <table id="table_id" class="table" cellspacing="0" width="100%">

                                <thead>
                                    @if (session()->has('message-success-delete') != '' || session()->get('message-danger-delete') != '')
                                        <tr>
                                            <td colspan="3">
                                                @if (session()->has('message-success-delete'))
                                                    <div class="alert alert-success">
                                                        {{ session()->get('message-success-delete') }}
                                                    </div>
                                                @elseif(session()->has('message-danger-delete'))
                                                    <div class="alert alert-danger">
                                                        {{ session()->get('message-danger-delete') }}
                                                    </div>
                                                @endif
                                            </td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th>@lang('common.title')</th>
                                        <th>@lang('common.action')</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($levels as $level)
                                        <tr>
                                            <td>{{ $level->level }}</td>
                                            <td>
                                                <x-drop-down />
                                                <a class="dropdown-item"
                                                    href="{{ route('question-level-edit', [$level->id]) }}">@lang('common.edit')</a>
                                                <a class="dropdown-item" data-toggle="modal"
                                                    data-target="#deleteLevelModal{{ $level->id }}"
                                                    href="#">@lang('common.delete')</a>
                        </div>
                    </div>
                    </td>
                    </tr>
                    <div class="modal fade admin-query" id="deleteLevelModal{{ $level->id }}">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">@lang('exam.delete_question_level')</h4>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>

                                <div class="modal-body">
                                    <div class="text-center">
                                        <h4>@lang('common.are_you_sure_to_delete')?</h4>
                                    </div>

                                    <div class="mt-40 d-flex justify-content-between">
                                        <button type="button" class="primary-btn tr-bg"
                                            data-dismiss="modal">@lang('common.cancel')</button>
                                        {{ html()->form('DELETE', route('question-level-delete', $level->id))->attribute('enctype', 'multipart/form-data')->open() }}
                                        <button class="primary-btn fix-gr-bg" type="submit">@lang('common.delete')</button>
                                        {{ html()->form()->close() }}
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    @endforeach
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
        </div>
        </div>
    </section>
@endsection

@include('backEnd.partials.data_table_js')
